import {Request, ResponsePatcher} from "../../patch";
import * as syncRequest from "sync-request";
import {Utils} from "../../../utils/utils";
import idx from 'idx';

export class WizardsResponsePatcher implements ResponsePatcher {
    constructor(readonly type: string, readonly subtype: string) {
    }

    patch(jsonBody: any, request?: Request): any {
        for (const entry of jsonBody) {
            const mids = this.getMids(entry);
            this.patchEntry(entry, mids);
        }
        return jsonBody;
    }

    getMids(entry: any): readonly string[] {
        const messages = idx(entry, _ => _.messageBatch.messages);
        if (messages == null) {
            return [];
        }
        const result = [];
        for (const message of messages) {
            result.push(message.mid);
        }
        return result;
    }

    patchEntry(entry: any, mids: readonly string[]) {
        const widgets = [];
        for (const mid of mids) {
            const widget = {
                info: {
                    mid: mid,
                    type: this.type,
                    subtype: this.subtype,
                }
            };
            widgets.push(widget);
        }
        entry.widgets = widgets;
    }
}
