import * as toxy from 'toxy';

export interface Rule {
}

export class Rules {
    static probability(percentage: number): Rule {
        return toxy.rules.probability(percentage);
    }

    static timeThreshold(duration: number, period: number): Rule {
        return toxy.rules.timeThreshold({
            duration: duration,
            period: period
        });
    }

    static method(method: string|string[]): Rule {
        return toxy.rules.method(method);
    }

    static contentType(value: string): Rule {
        return toxy.rules.contentType(value);
    }
}