import {AddressInfo, createServer} from "net";
import * as crypto from "crypto";
import {BinaryLike} from "crypto";

export class Utils {
    static randomFreePort(cb: (number) => void) {
        let server = createServer();
        server.on('error', err => console.error(err));
        server.on('listening', () => {
            let serverAddress = server.address() as AddressInfo;
            server.close(() => cb(serverAddress.port))
        });
        server.listen(0)
    }

    static endsWith(s: string, suffix: string): boolean {
        return s.indexOf(suffix, this.length - suffix.length) !== -1;
    };

    static parseIntUnsafe(s: string) {
        if (s === '0') {
            return 0
        }
        let n = parseInt(s);
        if (!n) {
            throw Error(`Can't parse int from '${s}'!`)
        }
        return n;
    }

    static parseFloatUnsafe(s: string) {
        let f = parseFloat(s);
        if (!f) {
            throw Error(`Can't parse float from '${s}'!`)
        }
        return f;
    }

    static md5(data: BinaryLike) {
        return crypto.createHash('md5').update(data).digest("hex");
    }

    static isAsync(func) {
        const STRIP_COMMENTS = /(\/\/.*$)|(\/\*[\s\S]*?\*\/)|(\s*=[^,\)]*(('(?:\\'|[^'\r\n])*')|("(?:\\"|[^"\r\n])*"))|(\s*=[^,\)]*))/mg;
        const  ARGUMENT_NAMES = /([^\s,]+)/g;
        function getParamNames() {
            let fnStr = func.toString().replace(STRIP_COMMENTS, '');
            let result = fnStr.slice(fnStr.indexOf('(')+1, fnStr.indexOf(')')).match(ARGUMENT_NAMES);
            if(result === null)
                result = [];
            return result;
        }
        let params = getParamNames();
        return params[params.length - 1] === "cb";
    }
}
