#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys

sys.path.append("/usr/share/xeno/")
from xeno_monitor import get_sharpei_stat, get_acquired_buckets_info, get_db_cursor, fetch


FILENAME = "/var/tmp/all_uids.txt"

uids = []
current_buckets = []
try:
    current_buckets = get_acquired_buckets_info()
except:
    pass
for bucket in current_buckets:
    for shard in bucket["shards"]:
        shard_id = shard["id"]
        sharpei_stat = get_sharpei_stat()
        if shard_id not in sharpei_stat:
            continue
        cursor = get_db_cursor(shard_id)
        uids += fetch(
            cursor,
            "SELECT DISTINCT m.uid FROM mailish.auth_data m JOIN mail.users u ON m.uid=u.uid WHERE u.is_here=true AND u.is_deleted=false;",
        )


uids_file = open(FILENAME, "w")
for uid in uids:
    uids_file.write(str(uid[0]) + "\n")
