#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys

sys.path.append("/usr/share/xeno/")
from xeno_monitor import *
import json
import argparse

SELECT_ALL_MAILISH_QUERY = "SELECT uid FROM mailish.accounts"
SELECT_MAILISH_WITH_AUTH_QUERY = "SELECT DISTINCT uid FROM mailish.auth_data"


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("--with_auth", help="select only users with auth data", action="store_true")
    args = parser.parse_args()
    if args.with_auth:
        users = get_xeno_users_with_auth()
    else:
        users = get_all_xeno_users()
    print_users(users)


def get_all_xeno_users():
    shards = get_sharpei_stat().keys()
    ret = []
    for shard_id in shards:
        cur = get_db_cursor(shard_id)
        ret += fetch(cur, SELECT_ALL_MAILISH_QUERY)
    return ret


def get_xeno_users_with_auth():
    shards = get_sharpei_stat().keys()
    ret = []
    for shard_id in shards:
        cur = get_db_cursor(shard_id)
        ret += fetch(cur, SELECT_MAILISH_WITH_AUTH_QUERY)
    return ret


def print_users(users):
    for user in users:
        print(user["uid"])


if __name__ == "__main__":
    main()
