#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys

sys.path.append("/usr/share/xeno/")
import yaml

from xeno_monitor import load_url, get_sharpei_stat, get_db_cursor, fetch_one


def get_shards():
    shards = list()
    total_users = 0
    for shard_id in get_sharpei_stat().keys():
        cursor = get_db_cursor(shard_id)
        users_count = fetch_one(
            cursor,
            "select count(distinct m.uid) from mailish.auth_data as m join mail.users as u on m.uid=u.uid where u.is_here=true and u.is_deleted=false;",
        )
        total_users += users_count
        shards.append({"id": shard_id.encode("utf-8"), "users_count": users_count})
    return shards, total_users


def add_shard_to_bucket(shards, limit, bucket):
    sorted_shards = sorted(shards, key=lambda k: k["users_count"], reverse=True)
    for shard in sorted_shards:
        if bucket["users_count"] + shard["users_count"] <= limit or bucket["users_count"] == 0:
            bucket["shards"].append(shard["id"])
            bucket["users_count"] += shard["users_count"]
            shards.remove(shard)
            break


def make_cfg(shards, limit, bucket_count):
    buckets = dict()
    for i in range(bucket_count):
        buckets[i] = {"users_count": 0, "shards": list()}
    previos_len = 0
    current_len = 0
    current_bucket = 0
    while len(shards):
        current_len = len(shards)
        for bucket in buckets:
            add_shard_to_bucket(shards, limit, buckets[bucket])
        if len(shards) == current_len:
            limit += limit * 0.05
    result_yml = {"config": dict()}
    result_yml["config"]["buckets"] = list()
    buckets = sorted(buckets.items(), key=lambda k: k[1]["users_count"], reverse=True)
    for i in range(bucket_count):
        bucket_name = "b{}".format(i)
        print "bucket {} has {} users".format(bucket_name, buckets[i][1]["users_count"])
        result_yml["config"]["buckets"].append(
            {"name": bucket_name, "shards": buckets[i][1]["shards"]}
        )
    return result_yml


def main():
    if len(sys.argv) < 3:
        print "Usage make_buckets_conf.py <buckets_count> <file_path>"
        return

    buckets_count = int(sys.argv[1])
    result_file_path = sys.argv[2]
    shards, total_users = get_shards()

    limit_per_bucket = int(total_users / buckets_count)
    print "buckets count {}".format(buckets_count)
    print "total users {}".format(total_users)
    print "limit per bucket {}".format(limit_per_bucket)
    with open(result_file_path, "w") as yaml_file:
        yaml.dump(make_cfg(shards, limit_per_bucket, buckets_count), yaml_file, indent=4)


if __name__ == "__main__":
    main()
