#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

PATH="/usr/sbin:/usr/bin:/sbin:/bin"

logfile="/var/log/$QLOUD_APPLICATION/access.log"

ts=$(date +%s)

timetail -n 60 -r '^tskv	tskv_format=xeno-access-log	timestamp=(\d\d\d\d-\d\d-\d\d \d\d:\d\d:\d\d)' "$logfile" | head -n -1 | \
    tr '[:upper:]' '[:lower:]' | awk -F $'\t' -v ts="$ts" '
    @include "/usr/share/yandex-mail-common/metrics-util.awk"
    @include "/usr/share/xeno/monitoring.d/xeno-util.awk"

    /request=/ {
        metrics["http.total"]++

        code = "unknown"
        request = ""
        exec_time = 0
        x_request_attempt = ""
        imap_server = ""
        auth_status = ""
        host = ""
        api_status = ""

        for (i=1; i <= NF; i++) {
            if ($i ~ /^status_code=/) {
                code = substr($i, 13)
                if (code < 100) next
            } else if ($i ~ /^request=/) {
                offset = length("request=") + 1
                end = index($i,"?")
                end = end > 0 ? end - offset : length($i)
                request = substr($i, offset, end)
                if (request ~ "/ping") next
                gsub("^(/)*","",request)
                gsub("[/]","_",request)
            } else if ($i ~ /^profiler_exec=/) {
                exec_time = substr($i, 15)
            } else if ($i ~ /^x_request_attempt=/) {
                x_request_attempt = substr($i, length("x_request_attempt=")+1)
            } else if ($i ~ /^imap_host=/) {
                imap_server = substr($i, length("imap_host=")+1)
                gsub("[.]","_",imap_server)
            } else if ($i ~ /^auth_status=/) {
                auth_status = substr($i, length("auth_status=")+1)
            } else if ($i ~ /^host=/) {
                host = substr($i, length("host=")+1)
            } else if ($i ~ /^api_status=/) {
                api_status = substr($i, length("api_status=")+1)
            }
        }

        provider = get_provider(imap_server)

        if (x_request_attempt != "") {
            metrics["http.attempts."x_request_attempt]++
        }

        if (api_status != "") {
            metrics["http.statuses.total."api_status".tier_"provider]++
            metrics["http.statuses."request"."api_status".tier_"provider]++
        }

        if (auth_status != "" && host == "xeno.mail.yandex.net") {
            metrics["authorization.requests.tier_"provider]++
            if (auth_status != "success") {
                metrics["authorization.errors.tier_"provider]++
            }
        }

        host = ""
        imap_server = ""
        auth_status = ""

        collect_timings(exec_time, "http.timings.total", metrics)
        collect_timings(exec_time, "http.timings."request, metrics)
    }

    END {
        for (i in metrics) {
            value = metrics[i]
            if (i ~ /timings/) value = "["value"]"
            print i, value, ts
        }
    }
' | awk '
    match($1,/tier_/) {
        tier = substr($1, RSTART+RLENGTH)
        if (tier == "") tier = "none"
        print substr($1,1,RSTART-2), $2, $3, tier
    }
    !/tier_/ {
        print
    }
'