#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys

sys.path.append("/usr/share/xeno/")
import time
from xeno_monitor import list_controllers, get_sharpei_stat, timestamp

DUMPED_UIDS_MAX_LAG = 360
DUMPED_UIDS_FILENAME = "/var/tmp/all_uids.txt"
CURRENT_TS = time.time()


def get_uids_loaded_longer_than_lag(controllers_load_ts, uids):
    return [
        int(uid) for uid in uids if CURRENT_TS - int(controllers_load_ts[uid]) > DUMPED_UIDS_MAX_LAG
    ]


content = []
try:
    with open(DUMPED_UIDS_FILENAME) as f:
        content = f.readlines()
except:
    pass
all_uids = set([x.strip() for x in content])

controllers_load_ts = {}
try:
    controllers_load_ts = {
        descr["uid"]: descr["creation_time"]
        for descr in list_controllers()["controllers"]
        if descr["state"] != "no_auth_data"
    }
except:
    pass

additional_uids = set(controllers_load_ts.keys()) - all_uids
additional_uids = get_uids_loaded_longer_than_lag(controllers_load_ts, additional_uids)
print "controllers.additional_loaded %s %s" % (len(additional_uids), timestamp)
