#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

PATH="/usr/sbin:/usr/bin:/sbin:/bin"

logfile="/var/log/$QLOUD_APPLICATION/api.log"

ts=$(date +%s)
prefix="http.requests."

timetail -t imap -n 60 "$logfile" |  head -n -1 | tr '[:upper:]' '[:lower:]' | awk -F '[ =":?/{}]' -v prefix=$prefix -v ts=$ts '
    @include "/usr/share/yandex-mail-common/metrics-util.awk"
    /event=start/ {
        url = ""
        conn = ""
        for (i = 1; i+2 <= NF; ++i) {
            if ($i == "uri") {
                url = $(i+2)
            }
            if ($i == "conn") {
                conn = $(i+1)
            }
        }
        gsub("\\.", "_", url)
        host_by_conn[conn] = url
    }
    /event=fin/ {
        status = ""
        conn = ""
        for (i = 1; i+2 <= NF; ++i) {
            if ($i == "status") {
                status = $(i+1)
            }
            if ($i == "conn") {
                conn = $(i+1)
            }
            if ($i == "tm") {
                tm = $(i+5)
            }
        }
        host = host_by_conn[conn]
        if (length(host) > 0) {
            if (host ~ /qloud-c_yandex_net/) {
                host_status["internal." status]++
            } else {
                host_status[host "." status]++
            }
            collect_timings(tm, host, host_tm)
        }
    }
    END {
        for (i in host_status) {
            print prefix "status." i, host_status[i], ts
        }
        for (host in host_tm) {
            print prefix "timings." host, "[" host_tm[host] "]", ts
        }
    }
'
