#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys

sys.path.append("/usr/share/xeno/")
import re
import subprocess
import json
from xeno_monitor import (
    providers_state,
    get_first_sync_timings,
    timestamp,
    get_provider_by_imap_server,
)
from collections import defaultdict

IMAP_LOG_PATH = "/var/log/xeno/imap.log"


def increment(dictonary, key, val=1):
    if dictonary.get(key) is None:
        dictonary[key] = val
    else:
        dictonary[key] += val


def get_controllers_list(stat):
    controllers = {}
    for controller in stat["controllers"]:
        controllers[controller["uid"]] = controller
    return controllers


def read_imap_requests():
    imap_requests_cmd = 'timetail -n 60 -t imap {} | head -n -1 | grep "sending:"'.format(
        IMAP_LOG_PATH
    )
    p = subprocess.Popen(imap_requests_cmd, stdout=subprocess.PIPE, shell=True)
    imap_requests = p.communicate()[0].splitlines()
    return imap_requests


imap_requests = read_imap_requests()


def calc_provider_rpm():
    provider_rpm = {}
    for line in imap_requests:
        try:
            server = line.split(" ")[3].replace(".", "_")
            increment(provider_rpm, get_provider_by_imap_server(server))
        except Exception:
            pass
    return provider_rpm


def calc_provider_downloaded_messages_count():
    provider_downloaded_messages_count = {}
    for line in imap_requests:
        try:
            if line.find("BODY.PEEK") != -1:
                server = line.split(" ")[3].replace(".", "_")
                increment(provider_downloaded_messages_count, get_provider_by_imap_server(server))
        except Exception:
            pass
    return provider_downloaded_messages_count


provider_state_aggregated = defaultdict(lambda: defaultdict(int))
provider_state = providers_state()
for server, provider_stats in provider_state.iteritems():
    provider = get_provider_by_imap_server(server.replace(".", "_"))
    for state, count in provider_stats.iteritems():
        provider_state_aggregated[provider][state] += int(count)
for provider, provider_stats in provider_state_aggregated.iteritems():
    for state, count in provider_stats.iteritems():
        print "controllers.total.%s %s %s %s" % (state, count, timestamp, provider)

provider_rpm = calc_provider_rpm()
for provider, rpm in provider_rpm.iteritems():
    print "imap.rpm.%s %s %s" % (provider, rpm, timestamp)

provider_downloaded_messages_count = calc_provider_downloaded_messages_count()
for provider, downloaded_messages_count in provider_downloaded_messages_count.iteritems():
    print "imap.downloaded_messages.%s %s %s" % (provider, downloaded_messages_count, timestamp)

for timing, value in get_first_sync_timings(time=60).iteritems():
    print "sync.first_sync.duration.%s %d %s" % (timing, value, timestamp)
