#!/bin/bash
# fast-launch

[[ "$TRACE" ]] && set -x
set -eo pipefail

PATH="/usr/sbin:/usr/bin:/sbin:/bin"
ts=$(date +%s)
curl -s localhost:8092/metrics \
    | grep -v -e macs_pool_stats -e rate_controller -e congestion-control \
    | awk -v ts="$ts" '
        match($1,/_tier_([^_]+)/, tier) {
            if (tier[1] == "") tier[1] = "none"
            sub(substr($1, RSTART, RLENGTH), "", $1)
            print $1, $2, ts, tier[1]
            next
        }
        {
            print $0, ts
        }
    '
