#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

PATH="/usr/sbin:/usr/bin:/sbin:/bin"

logfile="/var/log/$QLOUD_APPLICATION/profiler.log"

ts=$(date +%s)

pa -S imap_client -t 30 "$logfile" | tr '[:upper:]' '[:lower:]' | awk -v ts="$ts" '
    @include "/usr/share/yandex-mail-common/metrics-util.awk"
    @include "/usr/share/xeno/monitoring.d/xeno-util.awk"

    BEGIN {
        srand()
    }

    {
        imap_server = $4
        gsub("[.]","_",imap_server)
        provider = get_provider(imap_server)
        command = tolower($5)
        exec_time = $6
        if (rand() < 0.33) {
            collect_timings(exec_time, "imap.timings."command".tier_"provider, metrics)
        }
        metrics["imap."command".total.tier_"provider]++
    }

    END {
        for (i in metrics) {
            value = metrics[i]
            if (i ~ /timings/) value = "["value"]"
            print i, value, ts
        }
    }
' | awk '
    match($1,/tier_/) {
        tier = substr($1, RSTART+RLENGTH)
        if (tier == "") tier = "none"
        print substr($1,1,RSTART-2), $2, $3, tier
    }
    !/tier_/ {
        print
    }
'
