#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys
import time

sys.path.append("/usr/share/xeno/")
from xeno_monitor import get_acquired_buckets_info, get_sharpei_stat

all_shards = [int(id) for id in get_sharpei_stat().keys()]
current_shards = list()
for bucket in get_acquired_buckets_info():
    for shard in bucket["shards"]:
        current_shards.append(int(shard["id"]))

timestamp = int(time.time())

print "shards.known.sum_max {} {}".format(sum(all_shards), timestamp)
print "shards.current.sum {} {}".format(sum(current_shards), timestamp)
