#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys

sys.path.append("/usr/share/xeno/")
import re
import subprocess
from xeno_monitor import get_store_requests_count, get_store_errors_by_type, timestamp

log_file = "/var/log/xeno/xeno.log"

str_log = (
    "timetail -t imap -n 60 {} | head -n -1"
    " | fgrep 'store message error'"
    " | sed 's/.*store message error. //'"
    " | sed 's/bad status: //'"
    " | sed 's/ /_/g'"
    " | sort"
    " | uniq -c"
).format(log_file)
p = subprocess.Popen(str_log, stdout=subprocess.PIPE, shell=True)
log = p.communicate()[0].splitlines()

for line in log:
    [count, error] = line.strip().split(" ")
    print "smtpgate.errors.%s %s %s" % (error, count, timestamp)


print "store.requests %s %s" % (get_store_requests_count(), timestamp)

store_errors = get_store_errors_by_type()
print "store.failures %s %s" % (sum(store_errors.values()), timestamp)
for error, count in store_errors.iteritems():
    print "store.errors.%s %s %s" % (error, count, timestamp)
