#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

ts=$(date +%s)
[[ -n "$QLOUD_ENVIRONMENT" ]] && cond_group="xeno_"$QLOUD_ENVIRONMENT || cond_group=$(cat /var/cond_group)

timetail -t imap -n 60 /var/log/xeno/xeno.log | head -n -1 | tr '[:upper:]' '[:lower:]' | awk -F'[ =,]' -v prefix=$prefix -v ts=$ts '
    /sync statistics:/{
        for (i = 1; i+7 <= NF; ++i) {
            if ($i == "phase" && $(i+5) < 1000000000000 && $(i+7) < 1000000000000) {
                commands[$(i+1)] += $(i+3);
                rx[$(i+1)] += $(i+5);
                tx[$(i+1)] += $(i+7)
            }
        }
    }
    END {
        for (i in commands) {
            print "sync.phase." i ".ext_mb.commands", commands[i], ts;
            print "sync.phase." i ".ext_mb.rx", rx[i], ts;
            print "sync.phase." i ".ext_mb.tx", tx[i], ts
        }
    }'

timetail -n 60 -r '^tskv\ttskv_format=xeno-log\ttimestamp=.{11}(\d\d:\d\d:\d\d)' /var/log/xeno/typed.log |
    head -n -1 | tr '[:upper:]' '[:lower:]' | awk -v prefix=$prefix -v ts=$ts '
        /type=new_message/{
            match($0, /ext_size=([0-9]+)/, size);
            match($0, /operation=([a-z_]+)/, operation);
            if (length(operation[1]) != 0 && length(size[1]) != 0) {
                msg_size[operation[1]] += size[1]
                msg_count[operation[1]] += 1
            }
        }
        END {
            for (i in msg_size) {
                print "sync.operation." i ".new_messages.size", msg_size[i], ts
                print "sync.operation." i ".new_messages.count", msg_count[i], ts
            }
        }'
