#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys
import os

sys.path.append("/usr/share/xeno/")
import socket
import json
import time
from xeno_monitor import list_controllers, get_sharpei_stat, load_json_with_tvm


BAD_KARMA_VALUE = 85
BLACKBOX_CHUNK_SIZE = 200
BLACKBOX_URL = "https://blackbox-mail.yandex.net/blackbox?method=userinfo&format=json&uid={uids}&userip={ip}&user_port={port}"
CURRENT_TS = time.time()
DUMPED_UIDS_FILENAME = "/var/tmp/all_uids.txt"
DUMPED_UIDS_MAX_LAG = 360
MISSING_UIDS_CACHE_FILE = "/var/tmp/missing_uids.json"
MY_IP = socket.getaddrinfo(socket.gethostname(), None, 0, 0, socket.AF_INET6)[0][4][0]
MY_PORT = 443
MISSING_USERS_THRESHOLD = 100


def get_only_good_karma_uids(uids):
    res = []

    while len(uids) > 0:
        chunk = []
        while len(chunk) < BLACKBOX_CHUNK_SIZE and len(uids) > 0:
            chunk.append(uids.pop())

        response = load_json_with_tvm(
            BLACKBOX_URL.format(uids=",".join(chunk), ip=MY_IP, port=MY_PORT)
        )
        for user in response["users"]:
            karma = int(user["karma"]["value"])

            if karma < BAD_KARMA_VALUE:
                res.append(user["id"])

    return res


def recalculate_missing_uids_cache(missing_uids):
    old_missing_cache = {}
    try:
        with open(MISSING_UIDS_CACHE_FILE) as f:
            old_missing_cache = json.loads(f.read())
    except:
        pass

    new_missing_cache = {}
    for uid in missing_uids:
        if uid in old_missing_cache:
            new_missing_cache[uid] = old_missing_cache[uid]
        else:
            new_missing_cache[uid] = CURRENT_TS

    with open(MISSING_UIDS_CACHE_FILE, "w") as f:
        f.write(json.dumps(new_missing_cache))

    return new_missing_cache


def get_uids_missing_longer_than_lag(missing_uids_cache, missing_uids):
    return [
        int(uid)
        for uid in missing_uids
        if CURRENT_TS - missing_uids_cache[uid] > DUMPED_UIDS_MAX_LAG
    ]


if CURRENT_TS - os.path.getmtime(DUMPED_UIDS_FILENAME) > DUMPED_UIDS_MAX_LAG:
    result = "0; OK"
    print result
    exit()

content = []
try:
    with open(DUMPED_UIDS_FILENAME) as f:
        content = f.readlines()
except:
    pass

dumped_uids = set([x.strip() for x in content])
current_uids = set()
try:
    current_uids = set([descr["uid"] for descr in list_controllers()["controllers"]])
except:
    pass

missing_uids = dumped_uids - current_uids
missing_uids = get_only_good_karma_uids(missing_uids)
missing_uids_cache = recalculate_missing_uids_cache(missing_uids)
missing_uids = get_uids_missing_longer_than_lag(missing_uids_cache, missing_uids)

if len(missing_uids) > MISSING_USERS_THRESHOLD:
    result = "2; %s: %s" % (len(missing_uids), missing_uids)
elif missing_uids:
    result = "1; %s: %s" % (len(missing_uids), missing_uids)
else:
    result = "0; OK"

print result[:200]
