import subprocess
import json
import re
import os
from collections import defaultdict
from yamail.graphite import *
from http import load_url, load_json
from tvm import load_url_with_tvm, load_json_with_tvm
from mdb import get_sharpei_stat, get_db_cursor, fetch, fetch_one
from retry import retry
from local_storage import LocalStorage

STATPORT = "8091"

ACQUIRED_BUCKETS_INFO_URL = "http://localhost:8080/acquired_buckets_info"
LIST_CONTROLLERS_URL = "http://localhost:8080/list_controllers"
PROVIDERS_STATE_URL = "http://localhost:8080/providers_state"

ACCESS_LOG = "/var/log/xeno/access.log"
XENO_LOG = "/var/log/xeno/xeno.log"
PA_LOG = "/var/log/xeno/profiler.log"

global project, cond_group, host, timestamp

if not "project" in globals():
    project = "mail"

if not "cond_group" in globals():
    cond_group = "xeno_" + str(os.getenv("QLOUD_ENVIRONMENT"))


def run_bash(script):
    process = subprocess.Popen(
        ["bash", "-c", script], stdout=subprocess.PIPE, stderr=subprocess.PIPE
    )
    stdout, stderr = process.communicate()
    return stdout


def get_provider_by_imap_server(server):
    if server.endswith("imap_mail_ru"):
        return "mailru"
    elif server.endswith("gmail_com"):
        return "gmail"
    elif server.endswith("outlook_com"):
        return "outlook"
    elif server.endswith("yahoo_com"):
        return "yahoo"
    return "custom"


STATPORT_CACHE = None


def get_statport_data():
    global STATPORT_CACHE
    if STATPORT_CACHE is None:
        script = "nc localhost {}".format(STATPORT)
        STATPORT_CACHE = json.loads(run_bash(script))

    return STATPORT_CACHE


CONTROLLERS_LIST_CACHE = None


def list_controllers():
    global CONTROLLERS_LIST_CACHE
    if CONTROLLERS_LIST_CACHE is None:
        CONTROLLERS_LIST_CACHE = json.loads(load_url(LIST_CONTROLLERS_URL))

    return CONTROLLERS_LIST_CACHE


def providers_state():
    return json.loads(load_url(PROVIDERS_STATE_URL))


def respond_monrun_by_percents(total, failures, warn_percent, crit_percent):
    percents = (failures * 100.0 / total) if total != 0 else 0

    if percents > crit_percent:
        print "2; %s" % percents
    elif percents > warn_percent:
        print "1; %s" % percents
    else:
        print "0; %s" % percents


def get_send_requests_count(time=60):
    filter_send_requests_cmd = (
        "timetail -t imap -n {time} {logfile} | head -n -1"
        '    | grep "send message started" -c'.format(time=time, logfile=XENO_LOG)
    )
    return int(run_bash(filter_send_requests_cmd))


def get_send_users_count(time=60):
    cmd = (
        "timetail -t imap -n {time} {logfile} | head -n -1"
        "    | grep \"send message started\" | awk '{{ print $5 }}'"
        "    | sort | uniq | wc -l".format(time=time, logfile=XENO_LOG)
    )
    return int(run_bash(cmd))


def get_send_failures_count(time=60):
    filter_send_failures_cmd = (
        "timetail -t imap -n {time} {logfile} | head -n -1"
        '    | grep "send error:" | grep -v "message is spam" -c'.format(
            time=time, logfile=XENO_LOG
        )
    )
    return int(run_bash(filter_send_failures_cmd))


def get_send_failed_users_count(time=60):
    cmd = (
        "timetail -t imap -n {time} {logfile} | head -n -1"
        '    | grep "send error:" | grep -v "message is spam" | grep -Po "user=\d+"'
        "    | sort | uniq | wc -l".format(time=time, logfile=XENO_LOG)
    )
    return int(run_bash(cmd))


def get_mobile_api_status_counters(time=60):
    filter_mobile_api_statuses = (
        "timetail -t imap -n {time} {logfile} | head -n -1"
        '  | grep -Po "mobile api response status: \\w+"'
        "  | sort | uniq -c"
        '  | sed "s/mobile api response status: //g"'.format(time=time, logfile=XENO_LOG)
    )

    data = run_bash(filter_mobile_api_statuses).split("\n")
    data = [line.strip() for line in data if line.strip()]
    res = {}
    for line in data:
        val, key = line.split(" ")
        res[key] = int(val)
    return res


def get_first_sync_count(time=60):
    filter_first_syncs = (
        "timetail -t imap -n {time} {logfile} | head -n -1"
        '  | grep -Po "\d+\s+\w+\s+authorizing \\(first sync\\)"'
        "  | awk '{{print $1}}'"
        "  | sort | uniq | wc -l".format(time=time, logfile=XENO_LOG)
    )
    return int(run_bash(filter_first_syncs))


def get_first_sync_errors(time=60):
    filter_first_sync_failures = (
        "timetail -t imap -n {time} {logfile} | head -n -1"
        '  | grep -Po "\d+\s+\w+\s+first sync error"'
        "  | awk '{{print $1}}'"
        "  | sort | uniq | wc -l".format(time=time, logfile=XENO_LOG)
    )
    return int(run_bash(filter_first_sync_failures))


FIRST_SYNC_INTERVALS = [10, 20, 30, 40, 50, 60]


def get_first_sync_timings(time=60):
    filter_first_syncs_durations = (
        "pa -S xeno -t {time} {logfile}"
        '    | grep -Po "first_sync.*"'
        "    | awk '{{print $3}}'"
        "    | sort --numeric".format(time=time, logfile=PA_LOG)
    )

    data = run_bash(filter_first_syncs_durations).split("\n")
    data = [float(entry) for entry in data if entry != ""]

    interval_pos = 0
    counter = 0
    res = {}

    data_pos = 0
    while data_pos < len(data):
        time = data[data_pos]
        if interval_pos < len(FIRST_SYNC_INTERVALS):
            current_interval = FIRST_SYNC_INTERVALS[interval_pos]
            if time > current_interval:
                res[str(current_interval) + "s"] = counter
                interval_pos += 1
                counter = 0
                continue
        counter += 1
        data_pos += 1

    while interval_pos < len(FIRST_SYNC_INTERVALS):
        current_interval = FIRST_SYNC_INTERVALS[interval_pos]
        res[str(current_interval) + "s"] = counter
        interval_pos += 1
        counter = 0

    res["inf"] = counter
    return res


def get_store_requests_count(time=60):
    filter_store_requests = (
        "timetail -t imap -n {time} {logfile} | head -n -1"
        '   | fgrep "storing message in local mailbox" -c'.format(time=time, logfile=XENO_LOG)
    )
    return int(run_bash(filter_store_requests))


def get_store_errors_by_type(time=60):
    filter_store_failures = (
        "timetail -t imap -n {time} {logfile} | head -n -1"
        '   | grep -Po "storing error: .*"'
        "   | sort | uniq -c"
        '   | sed "s/storing error: //g"'.format(time=time, logfile=XENO_LOG)
    )

    data = run_bash(filter_store_failures).split("\n")
    data = [line.strip() for line in data if line.strip()]
    res = {}
    for line in data:
        values = line.split(" ")
        num = values[0]
        error = "_".join(values[1:])
        res[error] = int(num)
    return res


def get_user_operation_completions(time=60):
    filter_user_operations = (
        "timetail -t imap -n {time} {logfile} | head -n -1"
        '  | grep -Po "user operation finished: .*"'
        "  | sort | uniq -c"
        '  | sed "s/user operation finished: //g"'.format(time=time, logfile=XENO_LOG)
    )

    data = run_bash(filter_user_operations).split("\n")
    data = [line.strip() for line in data if line.strip()]
    res = {}
    for line in data:
        values = line.split(" ")
        num = values[0]
        error = "_".join(values[1:])
        res[error] = int(num)
    return res


def get_acquired_buckets_info():
    return json.loads(load_url(ACQUIRED_BUCKETS_INFO_URL))


def get_rate_controller_stats():
    stats = get_statport_data()
    return stats["stat"]["modules"]["rate_controller"]


def get_authorizations(time=60):
    authorization_request = (
        "timetail -n {time} -r '^tskv\ttskv_format=xeno-access-log\ttimestamp=.{{11}}(\d\d:\d\d:\d\d)' {logfile} | head -n -1"
        " | grep 'request=/api/mobile/v1/auth_by_'"
    ).format(time=time, logfile=ACCESS_LOG)
    logs = run_bash(authorization_request).split("\n")
    logs = [line.strip() for line in logs if line.strip()]
    authorizations = defaultdict(lambda: {"requests": 0, "success": 0})
    for line in logs:
        result = re.findall(r"\timap_host=(.+?)\t", line)
        imap_host = "unknown"
        if len(result):
            imap_host = result[0].replace(".", "_")
        authorizations[imap_host]["requests"] += 1
        if line.find("auth_status=success") != -1:
            authorizations[imap_host]["success"] += 1
    return authorizations
