import json
import os


class LocalStorage:
    def __init__(self, path):
        self.path = path
        if os.path.isfile(path):
            self.state = json.loads(open(path, "r").read().strip())
        else:
            self.state = {}

    def get(self, key, defval=None):
        return self.state[key] if key in self.state else defval

    def set(self, key, val):
        self.state[key] = val
        open(self.path, "w").write(json.dumps(self.state))
