import psycopg2
import psycopg2.extras
from http import load_json

DB_USER = "xeno"
SHARPEI_URL = "http://sharpei.mail.yandex.net:80/v3/stat"
SHARPEI_CACHE = None


def get_sharpei_stat():
    global SHARPEI_CACHE
    if SHARPEI_CACHE is None:
        SHARPEI_CACHE = load_json(SHARPEI_URL)
    return SHARPEI_CACHE


def remove_not_alive(db_list):
    return [db for db in db_list if db["status"] == "alive"]


def select_by_role(db_list, role):
    for db in db_list:
        if db["role"] == role:
            return db
    return None


def select_host(db_list, master_only):
    db_list = remove_not_alive(db_list)
    if master_only:
        return select_by_role(db_list, "master")
    replica = select_by_role(db_list, "replica")
    if replica:
        return replica
    return select_by_role(db_list, "master")


def get_db_cursor(shard_id, master_only=False):
    shard = get_sharpei_stat()[shard_id]
    db = select_host(shard["databases"], master_only)
    if db is None:
        raise Exception("shard {} not found".str(shard_id))
    conn_str = "host={} port={} dbname={} user={}".format(
        db["address"]["host"], db["address"]["port"], db["address"]["dbname"], DB_USER
    )
    conn = psycopg2.connect(conn_str)
    conn.autocommit = True
    return conn.cursor(cursor_factory=psycopg2.extras.DictCursor)


def fetch(cursor, command):
    cursor.execute(command)
    return cursor.fetchall()


def fetch_one(cursor, command):
    cursor.execute(command)
    return cursor.fetchone()[0]
