from http import load_url, load_json
import json


def load_json_with_tvm(host, add_headers=None, post_data=None):
    resp = load_url_with_tvm(host, add_headers, post_data)
    return json.loads(resp)


def load_url_with_tvm(host, add_headers=None, post_data=None):
    headers = {"X-Ya-Service-Ticket": get_service_ticket(host)}
    if add_headers:
        headers.update(add_headers)
    return load_url(host, headers, post_data)


def get_service_ticket(host):
    dst = host.replace("http://", "").replace("https://", "")
    if "?" in dst:
        dst = dst[: dst.find("?")]
    if "/" in dst:
        dst = dst[: dst.find("/")]
    resp = load_json(
        "http://localhost:1/tvm/tickets?dsts={}".format(dst),
        add_headers={"Authorization": get_tvm_token()},
    )
    return resp[dst]["ticket"]


def get_tvm_token():
    key = "QLOUD_TVM_TOKEN"
    value = None
    with open("/etc/environment", "r") as env:
        for param in env:
            if key in param:
                value = param.strip()[len(key) + 1 :]
    if value is None:
        raise Exception("QLOUD_TVM_TOKEN not found")
    return value
