#pragma once

#include <common/account.h>
#include <common/base32.h>
#include <common/gzip.h>

#include <sstream>

namespace xeno { namespace {

std::string make_mailish_id(const account_t& account)
{
    std::stringstream mailish_stream;
    static const char delimeter = '\n';

    mailish_stream << delimeter << account.imap_login << delimeter << account.imap_ep.host
                   << delimeter << account.imap_ep.port << delimeter << account.smtp_login
                   << delimeter << account.smtp_ep.host << delimeter << account.smtp_ep.port;

    return base32::encode(gzip::compress(mailish_stream.str()));
}

}}
