#include "revoke_token.h"
#include <ymod_httpclient/cluster_client.h>

namespace xeno::auth {

void revoke_token(context_ptr task_ctx, const std::string& token, const oauth_internal_cb& cb)
{
    auto request = http::request_t::POST("/api/1/token/revoke?consumer=mail", "token_id=" + token);

    auto client = yplatform::find<yhttp::cluster_client>("oauth_internal_client");
    client->async_run(
        task_ctx,
        std::move(request),
        [cb = cb, task_ctx = task_ctx](error ec, yhttp::response http_resp) {
            auto err = code::ok;
            if (ec)
            {
                YLOG(task_ctx->logger(), error) << "revoke token error: code=" << ec.message();
                err = code::cannot_revoke_token;
            }
            else
            {
                json::value result;
                json::reader reader;
                if (!reader.parse(http_resp.body, result))
                {
                    YLOG(task_ctx->logger(), error) << "revoke token error: bad json";
                    err = code::cannot_revoke_token;
                }
                else
                {
                    auto status = result["status"];
                    if (status.isNull() || status != "ok")
                    {
                        auto errors = result["errors"];
                        if (!errors.isNull())
                        {
                            std::vector<std::string> error_messages;
                            for (auto& error : errors)
                            {
                                error_messages.push_back(error.asString());
                            }
                            YLOG(task_ctx->logger(), error)
                                << "revoke token error: "
                                << boost::algorithm::join(error_messages, ", ");
                        }
                        else
                        {
                            YLOG(task_ctx->logger(), error) << "revoke token error: unknown error";
                        }
                        err = code::cannot_revoke_token;
                    }
                }
            }
            cb(err);
        });
}

}
