#pragma once

#include <common/http.h>

#include <yplatform/ptree.h>

#include <memory>
#include <string>

namespace xeno::auth::social {

struct social_settings
{
    social_settings() = default;
    social_settings(const yplatform::ptree& cfg)
    {
        consumer = cfg.get("consumer", "");
        access_token_ttl_penalty = cfg.get("access_token_ttl_penalty", access_token_ttl_penalty);
        auto paths = cfg.get_child("paths");
        access_url = paths.get("access", "");
        refresh_url = paths.get("refresh", "");
        task_by_token_url = paths.get("task_by_token", "");
    }

    std::string access_url;
    std::string refresh_url;
    std::string task_by_token_url;
    std::string consumer;
    duration access_token_ttl_penalty =
        time_traits::seconds(0); // extract from ttl to prevent auth with expired token
};
using social_settings_ptr = std::shared_ptr<social_settings>;

}
