#include "account.h"

#include <common/types.h>

namespace xeno {

yplatform::ptree account_t::dump()
{
    yplatform::ptree dump;
    dump.put<uid_t>("uid", uid);
    dump.put<std::string>("lock", has_security_lock() ? "true" : "false");
    dump.put<std::string>("last_sync_ts", time_traits::to_simple_string(last_sync_ts));
    dump.put<std::string>("imap", (imap_ep.host + ":" + std::to_string(imap_ep.port)));
    dump.put<std::string>("smtp", (smtp_ep.host + ":" + std::to_string(smtp_ep.port)));

    if (auth_data.size())
    {
        for (auto& auth : auth_data)
        {
            yplatform::ptree result;
            result.put<std::string>("auth_type", auth.type == auth_type::oauth ? "oauth" : "pass");
            result.put<std::string>("uuid", auth.uuid);
            dump.push_back(std::make_pair("auth_data", result));
        }
    }

    return dump;
}

}
