#pragma once

#include <common/karma.h>

#include <yplatform/time_traits.h>
#include <yplatform/ptree.h>

#include <boost/optional.hpp>
#include <memory>
#include <string>
#include <set>
#include <utility>

namespace xeno {

using token_id_t = std::string;

enum class auth_type : int
{
    oauth = 0,
    password
};

struct auth_data
{
    token_id_t xtoken_id;

    auth_type type{ auth_type::oauth };
    std::string imap_credentials;
    std::string smtp_credentials;
    std::string uuid;
    std::string oauth_app;

    std::time_t last_valid{ 0 };
    bool security_lock{ false };
    int tries_count{ 0 };

    bool operator==(const auth_data& other)
    {
        return xtoken_id == other.xtoken_id;
    }

    bool operator==(const std::string& xtoken_id)
    {
        return this->xtoken_id == xtoken_id;
    }
};

using uid_t = uint64_t;
using uid_vector = std::vector<uid_t>;
struct endpoint
{
    endpoint() = default;
    endpoint(const std::string& host, uint16_t port, bool ssl) : host(host), port(port), ssl(ssl)
    {
    }

    std::string host;
    uint16_t port = 0;
    bool ssl = true;
};
using endpoint_ptr = std::shared_ptr<endpoint>;
using endpoint_opt = boost::optional<endpoint>;
using auth_data_vector = std::vector<auth_data>;

struct account_t
{
    uid_t uid{ 0 };
    std::string email;
    std::time_t last_sync_ts{ std::time(
        nullptr) }; // used for notification filtering for old or moved letters
    std::string imap_login;
    endpoint imap_ep;
    std::string smtp_login;
    endpoint smtp_ep;
    auth_data_vector auth_data;
    karma_t karma;

    bool has_security_lock() const
    {
        for (auto& data : auth_data)
        {
            if (data.security_lock)
            {
                return true;
            }
        }
        return false;
    }

    yplatform::ptree dump();
};

using account_ptr = std::shared_ptr<account_t>;

}
