#include <common/base32.h>

#define _Bool bool
#include <libopendkim/dkim.h>
#undef _Bool

namespace xeno::base32 {

std::string encode(const std::string& data)
{
    auto encoded_size = data.size() * 2;
    std::string encoded(encoded_size, '\0');
    auto result = dkim_base32_encode(&encoded[0], &encoded_size, &data[0], data.size());
    encoded.resize(result);
    return encoded;
}

}
