#pragma once

#include <string>

namespace xeno { namespace {

std::string get_domain_by_email(const std::string& email)
{
    auto iter = email.find("@");
    if (iter != std::string::npos)
    {
        auto domain = email.substr(++iter);
        if (!domain.empty())
        {
            return domain;
        }
    }
    return std::string();
}

}}
