#include <common/gzip.h>

#include <boost/iostreams/filtering_streambuf.hpp>
#include <boost/iostreams/copy.hpp>
#include <boost/iostreams/filter/gzip.hpp>
#include <iterator>
#include <sstream>

namespace xeno::gzip {

std::string compress(const std::string& data)
{
    std::stringstream data_stream(data);
    boost::iostreams::filtering_streambuf<boost::iostreams::input> compress;
    compress.push(boost::iostreams::gzip_compressor());
    compress.push(data_stream);
    return std::string(std::istreambuf_iterator<char>(&compress), std::istreambuf_iterator<char>());
}

}
