#include "http.h"

#include <yplatform/time_traits.h>
#include <yplatform/encoding/url_encode.h>
#include <yplatform/util/sstream.h>

#include <boost/algorithm/string/join.hpp>

namespace xeno::http {

std::string make_url(const std::string& host, uint16_t port, const std::string& path)
{
    constexpr auto port_size = sizeof("65535");
    std::string url;
    yplatform::sstream url_stream(url, host.size() + port_size + path.size());
    url_stream << host;
    if (port && port != DEFAULT_PORT)
    {
        url_stream << ":" << std::to_string(port);
    }
    url_stream << path;

    return url;
}

std::string make_url(const std::string& host, const std::string& path)
{
    return make_url(host, DEFAULT_PORT, path);
}

std::string make_body_url_encoded(const args_vector& args)
{
    std::string body = boost::algorithm::join(args, "&");
    return yplatform::url_encode<std::string>(body);
}

std::string make_url(const yplatform::ptree& cfg)
{
    auto host = cfg.get("host", "");
    auto port = cfg.get<uint16_t>("port", 80);
    auto path = cfg.get("path", "");
    return http::make_url(host, port, path);
}

inline std::string make_tvm_header(const std::string& ticket)
{
    std::string header;
    yplatform::sstream header_stream(header);
    static const std::string header_name("ticket");
    header_stream << header_name << ": " << ticket << "\r\n";
    return header;
}

void append_tvm2_user_header(request_t& req, const std::string& ticket)
{
    static const std::string header_name("X-Ya-User-Ticket");
    ymod_httpclient::add(req.headers, header_name, ticket);
}

}
