#pragma once

#include "context.h"
#include "errors.h"
#include "types.h"

#include <ymod_httpclient/call.h>
#include <ymod_httpclient/url_encode.h>
#include <yplatform/ptree.h>
#include <yplatform/find.h>
#include <yplatform/util/sstream.h>
#include <yplatform/coroutine.h>
#include <yplatform/yield.h>

#include <boost/shared_ptr.hpp>
#include <boost/algorithm/string/join.hpp>
#include <memory>
#include <vector>

namespace xeno::http {

using args_vector = std::vector<std::string>;

using request_t = yhttp::request;
using request_ptr = std::shared_ptr<request_t>;

using http_call_t = yhttp::call;
using http_call_ptr = boost::shared_ptr<http_call_t>;

using http_options_t = yhttp::options;

const uint16_t DEFAULT_PORT = 80;

std::string make_url(
    const std::string& host,
    uint16_t port = DEFAULT_PORT,
    const std::string& path = "");
std::string make_url(const std::string& host, const std::string& path = "");
std::string make_url(const yplatform::ptree& cfg);

template <typename Map>
inline std::string make_headers(const Map& map)
{
    std::string headers_str;
    yplatform::sstream headers_stream(headers_str);
    for (auto& [name, value] : map)
    {
        headers_stream << name << ": " << value << "\r\n";
    }
    return headers_str;
}

void append_tvm2_user_header(request_t& req, const std::string& ticket);

template <typename Map>
inline std::string make_body(const Map& map)
{
    std::vector<std::string> params;
    for (auto& [name, value] : map)
    {
        params.push_back(name + "=" + value);
    }
    return boost::algorithm::join(params, "&");
}

std::string make_body_url_encoded(const args_vector& args);

}

#include <yplatform/unyield.h>
