#include "json.h"

namespace xeno::json {

std::string to_string(const value& value)
{
    std::string result;
    if (value.isConvertibleTo(Json::ValueType::stringValue))
    {
        result = value.asString();
    }
    else
    {
        fast_writer writer;
        result = writer.write(value);
        // unfortunately, it writes ending \n
        result.resize(result.size() - 1);
    }
    return result;
}

value from_string(const std::string& json)
{
    reader reader;
    value result;

    bool parse_ok = reader.parse(json, result);
    if (!parse_ok)
    {
        throw std::runtime_error("invalid json");
    }
    return result;
}

}
