#pragma once

#include <json/value.h>
#include <json/reader.h>
#include <json/writer.h>
#include <json/json_features.h>

#include <memory>

namespace xeno::json {

using value = Json::Value;
using value_ptr = std::shared_ptr<value>;
using reader = Json::Reader;
using fast_writer = Json::FastWriter;

std::string to_string(const value& value);
value from_string(const std::string& json);

}
