#pragma once

#include <mail_errors/error_code.h>
#include <yplatform/util/sstream.h>

namespace xeno {

inline std::string mail_error_message(const mail_errors::error_code& err)
{
    std::string ret;
    auto message_length = sizeof(err.category().name()) + err.base().message().size() +
        err.what().size() + sizeof("{ category: , message: , description:  }");
    yplatform::sstream stream(ret, message_length);
    stream << "{ category: " << err.category().name() << ", message: " << err.base().message()
           << ", description: " << err.what() << " }";
    return ret;
}

}
