#pragma once

#include <yplatform/task_context.h>
#include <yplatform/log.h>

#include <msgpack.hpp>
#include <msgpack/type.hpp>

namespace xeno {

template <typename T>
bool unpack(yplatform::task_context_ptr ctx, const std::string& source, T& message) noexcept
{
    try
    {
        auto unpacked_msg = msgpack::unpack(source.data(), source.size());
        unpacked_msg.get().convert(message);
        return true;
    }
    catch (const std::exception& e)
    {
        YLOG_CTX_GLOBAL(ctx, error) << "unpack exception: " << e.what();
    }
    catch (...)
    {
        YLOG_CTX_GLOBAL(ctx, error) << "unpack unknown exception";
    }
    return false;
}

}
