#pragma once

#include <random>

namespace xeno {

template <typename T>
T random_int(T from, T to)
{
    static thread_local std::mt19937 gen_(time(0));
    std::uniform_int_distribution<T> randomizer(std::min(from, to), std::max(from, to));
    return randomizer(gen_);
}

}
