#pragma once

#include <vector>

namespace xeno {
template <typename Container>
std::vector<Container> split_for_chunks(const Container& container, size_t chunk_size)
{
    std::vector<Container> result = { {} };
    for (auto& value : container)
    {
        auto& current_containter = result.back();
        if (current_containter.size() >= chunk_size)
        {
            result.push_back({ value });
            continue;
        }
        current_containter.insert(current_containter.end(), value);
    }
    return result;
}
}
