#pragma once

#include <yplatform/task_context.h>
#include <yplatform/time_traits.h>
#include <yplatform/error.h>

#include <string>
#include <optional>

namespace xeno {

namespace time_traits = yplatform::time_traits;
using context_ptr = yplatform::task_context_ptr;

using time_traits::duration;
using time_traits::time_point;
using std::optional;

namespace ph = std::placeholders;
using error = yplatform::error;
using string = std::string;
using string_opt = optional<string>;

using shard_id = std::string;
using without_data_cb = std::function<void(error)>;
using string_opt_cb = std::function<void(error, string_opt)>;
using bool_cb = std::function<void(error, bool)>;

}
