#pragma once

#include <common/types.h>
#include <ymod_httpclient/cluster_client.h>
#include <yplatform/ptree.h>
#include <blowfish.h>

namespace xeno::encryption {

using versioned_keys = blowfish::password::versioned_keys;

struct iam_settings
{
    string node;
    string http_path;
    string accout_id;
    string key_id;
    string private_key;
    string public_key;
    time_traits::microseconds ttl;

    void parse_ptree(const yplatform::ptree& conf)
    {
        using namespace yplatform::time_traits;
        node = conf.get<string>("node");
        http_path = conf.get<string>("http_path");
        accout_id = conf.get<string>("accout_id");
        key_id = conf.get<string>("key_id");
        private_key = conf.get<string>("private_key");
        public_key = conf.get<string>("public_key");
        ttl = duration_cast<microseconds>(conf.get<duration>("ttl"));
    }
};

struct kms_settings
{
    bool enabled;
    string key_id;
    string node;

    void parse_ptree(const yplatform::ptree& conf)
    {
        enabled = conf.get<bool>("enabled");
        if (enabled)
        {
            key_id = conf.get<string>("key_id");
            node = conf.get<string>("node");
        }
    }
};

struct settings
{
    versioned_keys raw_keys;
    kms_settings kms;
    iam_settings iam;
    yhttp::cluster_client::settings http;

    void parse_ptree(const yplatform::ptree& conf)
    {
        auto keys_data = conf.equal_range("versioned_keys");
        for (auto& [name, version] : boost::make_iterator_range(keys_data))
        {
            raw_keys[version.get<uint32_t>("version")] = version.get<string>("key");
        }

        kms.parse_ptree(conf.get_child("kms_encryption"));
        if (kms.enabled)
        {
            iam.parse_ptree(conf.get_child("iam"));
            http.parse_ptree(conf.get_child("http"));
        }
    }
};

}
