#pragma once

#include "data_types/folder.h"
#include "data_types/message.h"
#include <common/account.h>
#include <common/errors.h>
#include <common/json.h>
#include <common/karma.h>

#include <functional>
#include <memory>
#include <string>

namespace xeno { namespace mailbox {
using string_ptr = std::shared_ptr<std::string>;

using folder_cb = std::function<void(error, folder_ptr)>;
using folder_vector_cb = std::function<void(error, folder_vector_ptr)>;
using mid_vector_cb = std::function<void(error, mid_vector_ptr)>;
using messages_vector_cb = std::function<void(error, message_vector_ptr)>;
using message_body_cb = std::function<void(error, string_ptr)>;
using imap_ids_transform_cb = std::function<void(error, imap_id_transform_map_ptr)>;
using mid_cb = std::function<void(error, mid_t)>;
using lid_cb = std::function<void(error, const lid&)>;
using fid_cb = std::function<void(error, fid_t)>;
using account_cb = std::function<void(error, account_t)>;
using ptree_ptr_cb = std::function<void(error, std::shared_ptr<yplatform::ptree>)>;
using json_cb = std::function<void(error, json::value)>;
using imap_id_and_uidvalidity_cb = std::function<void(error, imap_id_uidvalidity_pair)>;
using flags_cb = std::function<void(error, flags_ptr)>;
using sids_cb = std::function<void(error, std::vector<std::string> /*sids*/)>;
using karma_cb = std::function<void(error, const karma_t&)>;
using provider_cb = std::function<void(error, const std::string&)>;

struct ext_mailbox_ctx
{
    std::map<std::string, folder::type_t> folders_types;
};
using ext_mailbox_ctx_ptr = std::shared_ptr<ext_mailbox_ctx>;

}}
