#include "message.h"

namespace xeno::mailbox {

imap_id_vector_ptr message_helpers::to_imap_id_vector(message_vector_ptr messages)
{
    auto result = std::make_shared<imap_id_vector>();
    for (auto& msg : *messages)
    {
        result->push_back(msg.id);
    }
    return result;
}

fid_messages_map message_helpers::split_by_fid(message_vector messages)
{
    fid_messages_map result;
    for (auto& message : messages)
    {
        auto& messages_for_fid = result[message.fid];
        if (!messages_for_fid)
        {
            messages_for_fid = std::make_shared<mailbox::message_vector>();
        }
        messages_for_fid->push_back(message);
    }
    return result;
}

yplatform::ptree message::dump()
{
    yplatform::ptree dump;
    dump.put("num", num);
    dump.put("imap_id", id);
    dump.put("mid", mid);
    dump.put("status", to_string(status));
    dump.put("errors", errors_count);
    dump.put("saved_errors_count", saved_errors_count);
    dump.put_child("flags", flags.dump());

    return dump;
}

std::string message::to_string(status_t status)
{
    switch (status)
    {
    case status_t::ok:
        return "ok";
    case status_t::to_download_body:
        return "to_download_body";
    case status_t::to_update_flags:
        return "to_update_flags";
    case status_t::to_delete:
        return "to_delete";
    case status_t::to_load_from_local:
        return "to_load_from_local";
    default:
        return "undefined status";
    }
}

}
