#pragma once

#include "message.h"

namespace xeno::mailbox {

struct redownload_messages_state
{
    bool has_new_failures = true;
    bool has_another_messages_in_local_mb = true;
    message_vector_ptr messages = std::make_shared<message_vector>();
    uint32_t max_error_count_on_last_cache_update;
    struct
    {
        uint32_t errors_count;
        time_traits::duration delay;
    } current_group;
    time_traits::duration current_delay;
    time_traits::time_point last_message_download_time = time_traits::clock::now();

    mailbox::message_vector::iterator find_message(mailbox::imap_id_t id, mailbox::fid_t fid)
    {
        return std::find_if(messages->begin(), messages->end(), [&id, &fid](const auto& msg) {
            return msg.id == id && msg.fid == fid;
        });
    }
};

using redownload_messages_state_ptr = std::shared_ptr<redownload_messages_state>;
}
