#pragma once

#include "folder.h"

namespace xeno::mailbox {

struct sync_status
{
    struct folder_status
    {
        std::size_t external_messages_count = 0;
        bool api_read_lock = true;
        bool turbo_sync_running = true;
    };

    std::map<fid_t, folder_status> folders;
    time_traits::duration inbox_sync_lag = time_traits::duration::min();
    time_traits::duration total_sync_lag = time_traits::duration::min();
};

}
