#pragma once

#include "imap_wrapper.h"

#include <mailbox/data_types/flags.h>
#include <mailbox/data_types/folder.h>

namespace xeno::mailbox::external {

namespace ph = std::placeholders;

namespace {

flags_t convert_flags(const ymod_imap_client::ImapMessage& msg, folder::type_t folder_type)
{
    flags_t flags;

    if (msg.flags & ymod_imap_client::FetchResponse::mf_answered)
        flags.system_flags.insert(system_flag_t::answered);

    if (msg.flags & ymod_imap_client::FetchResponse::mf_flagged)
        flags.system_flags.insert(system_flag_t::flagged);

    if (msg.flags & ymod_imap_client::FetchResponse::mf_deleted)
        flags.system_flags.insert(system_flag_t::deleted);

    if (msg.flags & ymod_imap_client::FetchResponse::mf_seen)
        flags.system_flags.insert(system_flag_t::seen);

    // for drafts folder we should unconditionally mark drafts flag
    if (msg.flags & ymod_imap_client::FetchResponse::mf_draft ||
        folder_type == folder::type_t::drafts)
        flags.system_flags.insert(system_flag_t::draft);

    if (msg.flags & ymod_imap_client::FetchResponse::mf_recent)
        flags.system_flags.insert(system_flag_t::recent);

    return flags;
}

message convert_message(const ymod_imap_client::ImapMessage& msg, folder::type_t folder_type)
{
    message result;
    result.num = msg.num;
    result.id = msg.uid;
    result.flags = convert_flags(msg, folder_type);
    result.size = msg.size;
    result.date = msg.internaldate;
    return result;
}

message_vector_ptr convert_messages(
    ymod_imap_client::ImapMessageVector messages,
    folder::type_t folder_type)
{
    message_vector_ptr result = std::make_shared<message_vector>();
    result->reserve(messages.size());

    std::transform(
        messages.begin(),
        messages.end(),
        std::back_inserter(*result),
        std::bind(convert_message, ph::_1, folder_type));

    return result;
}

}
}
