#pragma once

#include "external_mailbox_settings.h"
#include "imap_wrapper.h"

#include <mailbox/data_types/folder.h>
#include <mailbox/common.h>

namespace xeno::mailbox::external {

using folder_name_type_map = std::map<std::string, folder::type_t>;

// returns same order every sync
// it matters for system folders by name recognition
ymod_imap_client::ImapListPtr fix_folders_hierarchy(
    ymod_imap_client::ImapListPtr imap_list,
    bool is_gmail);

folder_vector_ptr convert_imap_folders(
    ymod_imap_client::ImapListPtr imap_list,
    const folder_name_type_map& folders_type);

void get_folders(imap_wrapper_ptr client, settings_ptr settings, const folder_vector_cb& cb);

}
