#pragma once

#include "imap_wrapper.h"
#include "external_mailbox_settings.h"
#include "convert_messages.h"

#include <mailbox/data_types/folder.h>
#include <mailbox/common.h>

#include <yplatform/coroutine.h>
#include <yplatform/yield.h>

namespace xeno::mailbox::external {

class get_messages_info_by_num_op : public yplatform::log::contains_logger
{
    using yield_context = yplatform::yield_context<get_messages_info_by_num_op>;

public:
    get_messages_info_by_num_op(
        ext_mailbox_ctx_ptr ext_ctx,
        const path_t& path,
        imap_id_t top,
        imap_id_t bottom,
        const messages_vector_cb& cb,
        imap_wrapper_ptr client,
        settings_ptr settings,
        const yplatform::log::source& logger)
        : yplatform::log::contains_logger(logger)
        , ext_ctx(ext_ctx)
        , client(client)
        , path(path.to_string(), path.delim)
        , sequence(
              boost::lexical_cast<std::string>(top) + ":" +
              boost::lexical_cast<std::string>(bottom))
        , cb(cb)
        , settings(settings)
    {
    }

    void operator()(yield_context ctx, error err = {})
    {
        try
        {
            reenter(ctx)
            {
                yield client->examine(path, ctx);
                if (err) yield break;

                yield client->num_fetch(sequence, ctx);
                if (err) yield break;

                result = convert_messages(
                    imapMessages->messages, ext_ctx->folders_types[path.asString()]);
            }
        }
        catch (const std::exception& e)
        {
            YLOG_L(error) << "external mailbox get_messages_info_by_num_op exception: " << e.what();
            err = code::external_mailbox_exception;
        }

        if (ctx.is_complete())
        {
            cb(err, result);
        }
    }

    void operator()(yield_context ctx, error err, ymod_imap_client::MessageSetPtr messagesResult)
    {
        imapMessages = messagesResult;
        (*this)(ctx, err);
    }

protected:
    ext_mailbox_ctx_ptr ext_ctx;
    imap_wrapper_ptr client;

    ymod_imap_client::Utf8MailboxName path;
    std::string sequence;
    ymod_imap_client::MessageSetPtr imapMessages;

    messages_vector_cb cb;
    message_vector_ptr result;

    settings_ptr settings;
};

}
