#pragma once

#include <common/types.h>
#include <mailbox/data_types/folder.h>
#include <ymod_imapclient/imap_client.h>
#include <yplatform/ptree.h>

namespace yplatform {

template <>
inline void ptree_convert(const ptree& val, xeno::mailbox::folder::type_t& out)
{
    using folder_type = xeno::mailbox::folder::type_t;
    static constexpr std::initializer_list<std::pair<const char*, folder_type>> data = {
        { "Inbox", folder_type::inbox },   { "Sent", folder_type::sent },
        { "Trash", folder_type::trash },   { "Spam", folder_type::spam },
        { "Drafts", folder_type::drafts }, { "Outbox", folder_type::outbox }
    };
    static const std::map<string, folder_type> mapping(data.begin(), data.end());
    auto type_name = val.get_value<string>();
    auto it = mapping.find(type_name);
    if (it != mapping.end())
    {
        out = it->second;
    }
    else
    {
        out = folder_type::user;
    }
}

template <>
inline void ptree_convert(const ptree& val, ymod_imap_client::ImapClient::OauthLoginType& out)
{
    using login_type = ymod_imap_client::ImapClient::OauthLoginType;
    static constexpr std::initializer_list<std::pair<const char*, login_type>> data = {
        { "literal", login_type::SinglelineLiteral },
        { "quoted", login_type::SinglelineQuoted },
        { "multiline", login_type::Multiline }
    };
    static const std::map<string, login_type> mapping(data.begin(), data.end());
    auto type_name = val.get_value<string>();
    auto it = mapping.find(type_name);
    if (it != mapping.end())
    {
        out = it->second;
    }
    else
    {
        throw std::runtime_error("unknown login type for imap: " + type_name);
    }
}

}
