#pragma once

#include <stdint.h>

namespace xeno::mailbox::external {

struct statistics
{
    uint32_t command_count{ 0 };
    uint64_t received_bytes{ 0 };
    uint64_t sent_bytes{ 0 };

    statistics& operator+=(const statistics& other)
    {
        command_count += other.command_count;
        received_bytes += other.received_bytes;
        sent_bytes += other.sent_bytes;
        return *this;
    }
};

}
