#pragma once

#include "../data_types/folder.h"

#include <macs_pg/macs_pg.h>

namespace xeno::mailbox::local {

inline folder::type_t to_folder_type(const macs::Folder::Symbol& symbol)
{
    using sym = macs::Folder::Symbol;
    folder::type_t ret;
    if (symbol == sym::inbox)
    {
        ret = folder::type_t::inbox;
    }
    else if (symbol == sym::sent)
    {
        ret = folder::type_t::sent;
    }
    else if (symbol == sym::trash)
    {
        ret = folder::type_t::trash;
    }
    else if (symbol == sym::spam)
    {
        ret = folder::type_t::spam;
    }
    else if (symbol == sym::drafts)
    {
        ret = folder::type_t::drafts;
    }
    else if (symbol == sym::outbox)
    {
        ret = folder::type_t::outbox;
    }
    else
    {
        ret = folder::type_t::user;
    }
    return ret;
}

inline mailbox::folder to_folder(
    const macs::Folder& folder,
    const macs::MailishFolderChunk& mailish_folders)
{
    mailbox::folder ret;
    ret.fid = folder.fid();
    ret.type = to_folder_type(folder.symbolicName());
    auto it = std::find_if(
        mailish_folders.begin(),
        mailish_folders.end(),
        [fid = folder.fid()](const macs::MailishFolder& f) { return f.fid() == fid; });
    if (it != mailish_folders.end())
    {
        ret.path = path_t(
            it->path(), 0); // NOTE if folder is not a mailish folder it would have empty path
        ret.uidvalidity = it->uidValidity();
        ret.downloaded_range = imap_range{ it->downloadedRangeEnd(), it->downloadedRangeBegin() };
    }
    return ret;
}

inline std::optional<macs::Tab::Type> to_macs_tab(tab_opt tab)
{
    std::optional<macs::Tab::Type> res;
    if (tab)
    {
        switch (*tab)
        {
        case tab_type::relevant:
            res = macs::Tab::Type::relevant;
        case tab_type::news:
            res = macs::Tab::Type::news;
        case tab_type::social:
            res = macs::Tab::Type::social;
        }
    }
    return res;
}

}
