#pragma once

#include <common/http.h>
#include <common/json.h>
#include <mailbox/common.h>
#include <mailbox/data_types/folder.h>
#include <mailbox/data_types/store_request.h>

namespace xeno::mailbox::local {

class sendbernar_client
    : public std::enable_shared_from_this<sendbernar_client>
    , public yplatform::log::contains_logger
{
    using json_reader = json::reader;

public:
    sendbernar_client(context_ptr ctx, const yplatform::log::source& logger);

    void compose_draft(
        uid_t uid,
        const std::string& user_ticket,
        store_request_ptr request,
        const json_cb& cb);
    void compose_message(
        uid_t uid,
        const std::string& user_ticket,
        send_request_ptr request,
        const json_cb& cb);

protected:
    void compose_cb(
        const json_cb& cb,
        error ec = {},
        yhttp::response http_resp = yhttp::response());

    std::string make_compose_headers(store_request_ptr request);
    std::string make_compose_body(store_request_ptr request);
    json::value parse_compose_response(const std::string& body);
    std::string to_parts_json(const std::string& mid, const std::string& hid);
    std::string parse_error_response(const std::string& response);
    void replace_url_by_path(
        json::value& val,
        const std::string& old_key,
        const std::string& new_key);

private:
    context_ptr ctx;
};
using sendbernar_client_ptr = std::shared_ptr<sendbernar_client>;

}
