#include "errors.h"

#include <macs/errors.h>
#include <macs_pg/error.h>

namespace xeno::mdb {

struct database_category : public boost::system::error_category
{
    const char* name() const noexcept override
    {
        return "xeno::mdb::database_category";
    }

    std::string message(int v) const override
    {
        return error_message(static_cast<database_errors>(v));
    }

    bool equivalent(const boost::system::error_code& code, int condition) const noexcept override
    {
        switch (condition)
        {
        case database_errors::user_removed:
            return code == pgg::errc::userRemovedFromShard;
        case database_errors::tmp_error:
            return code.category() == macs::error::getCategory() ||
                code.category() == macs::pg::error::getSqlCategory() ||
                code.category() == macs::pg::error::getReadonlyCategory() ||
                code.category() == macs::pg::error::getConnectionCategory() ||
                code.category() == macs::pg::error::getCommonCategory();
        default:
            return boost::system::error_category::equivalent(code, condition);
        }
    }

    bool equivalent(int code, const boost::system::error_condition& condition) const
        noexcept override
    {
        return boost::system::error_category::equivalent(code, condition);
    }
};

const boost::system::error_category& get_database_category()
{
    static database_category instance;
    return instance;
}

}
